VERSION 5.00
Begin VB.Form SendTextData 
   Caption         =   "Send Text Data to Worksheet"
   ClientHeight    =   7020
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   4890
   LinkTopic       =   "Form1"
   ScaleHeight     =   7020
   ScaleWidth      =   4890
   StartUpPosition =   3  'Windows Default
   Begin VB.TextBox ebWkBName 
      Height          =   405
      Left            =   1200
      TabIndex        =   6
      Text            =   "Text1"
      Top             =   2400
      Width           =   1695
   End
   Begin VB.CommandButton ConnectOrigin 
      Caption         =   "Connect"
      Height          =   375
      Left            =   480
      TabIndex        =   4
      Top             =   1800
      Width           =   1215
   End
   Begin VB.CommandButton DisconnectOrigin 
      Caption         =   "Disconnect"
      Enabled         =   0   'False
      Height          =   375
      Left            =   2280
      TabIndex        =   5
      Top             =   1800
      Width           =   1215
   End
   Begin VB.CheckBox chExitOrigin 
      Caption         =   "Exit Origin when Disconnect"
      Enabled         =   0   'False
      Height          =   375
      Left            =   240
      TabIndex        =   3
      Top             =   1320
      Width           =   2895
   End
   Begin VB.OptionButton AlwaysCreateNew 
      Caption         =   "Launch new instance of Origin"
      Height          =   255
      Left            =   240
      TabIndex        =   0
      Top             =   120
      Width           =   2775
   End
   Begin VB.OptionButton ConnectExistingOneFirst 
      Caption         =   "Connect to existing instance of Origin"
      Height          =   255
      Left            =   240
      TabIndex        =   1
      Top             =   480
      Value           =   -1  'True
      Width           =   3135
   End
   Begin VB.TextBox ebTextPrefix 
      Height          =   375
      Left            =   3240
      TabIndex        =   9
      Text            =   "Text1"
      Top             =   3720
      Width           =   1335
   End
   Begin VB.CommandButton SendData 
      Caption         =   "Send Data"
      Enabled         =   0   'False
      Height          =   495
      Left            =   840
      TabIndex        =   12
      Top             =   5400
      Width           =   1575
   End
   Begin VB.TextBox ebWksName 
      Height          =   405
      Left            =   1200
      TabIndex        =   7
      Text            =   "Text1"
      Top             =   3000
      Width           =   1695
   End
   Begin VB.CheckBox chkAppend 
      Caption         =   "&Append data as new rows"
      Enabled         =   0   'False
      Height          =   375
      Left            =   1320
      TabIndex        =   11
      Top             =   4800
      Width           =   2415
   End
   Begin VB.TextBox ebRows 
      Alignment       =   1  'Right Justify
      BeginProperty DataFormat 
         Type            =   1
         Format          =   "0"
         HaveTrueFalseNull=   0
         FirstDayOfWeek  =   0
         FirstWeekOfYear =   0
         LCID            =   1033
         SubFormatType   =   1
      EndProperty
      Height          =   375
      Left            =   1200
      TabIndex        =   8
      Text            =   "Text1"
      Top             =   3720
      Width           =   855
   End
   Begin VB.TextBox ebCols 
      Alignment       =   1  'Right Justify
      BeginProperty DataFormat 
         Type            =   1
         Format          =   "0"
         HaveTrueFalseNull=   0
         FirstDayOfWeek  =   0
         FirstWeekOfYear =   0
         LCID            =   1033
         SubFormatType   =   1
      EndProperty
      Height          =   375
      Left            =   1200
      TabIndex        =   10
      Text            =   "Text1"
      Top             =   4200
      Width           =   855
   End
   Begin VB.CheckBox chkSaveProject 
      Caption         =   "Save Origin project on Disconnect"
      Enabled         =   0   'False
      Height          =   375
      Left            =   120
      TabIndex        =   14
      Top             =   6000
      Width           =   3015
   End
   Begin VB.TextBox ebSaveFileName 
      Enabled         =   0   'False
      Height          =   375
      Left            =   120
      TabIndex        =   15
      Text            =   "Text1"
      Top             =   6480
      Width           =   4695
   End
   Begin VB.CommandButton ClearWks 
      Caption         =   "Clear Worksheet"
      Enabled         =   0   'False
      Height          =   495
      Left            =   2760
      TabIndex        =   13
      Top             =   5400
      Width           =   1575
   End
   Begin VB.CheckBox chkShowOrigin 
      Caption         =   "Show Origin application window"
      Height          =   375
      Left            =   240
      TabIndex        =   2
      Top             =   840
      Value           =   1  'Checked
      Width           =   2895
   End
   Begin VB.Label Label5 
      Alignment       =   1  'Right Justify
      Caption         =   "Workbook"
      Height          =   375
      Left            =   120
      TabIndex        =   20
      Top             =   2400
      Width           =   975
   End
   Begin VB.Label Label4 
      Alignment       =   1  'Right Justify
      Caption         =   "Text Prefix"
      Height          =   375
      Left            =   2280
      TabIndex        =   19
      Top             =   3720
      Width           =   855
   End
   Begin VB.Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "Worksheet"
      Height          =   375
      Left            =   120
      TabIndex        =   18
      Top             =   3000
      Width           =   975
   End
   Begin VB.Label Label2 
      Alignment       =   1  'Right Justify
      Caption         =   "Rows"
      Height          =   375
      Left            =   120
      TabIndex        =   17
      Top             =   3720
      Width           =   975
   End
   Begin VB.Label Label3 
      Alignment       =   1  'Right Justify
      Caption         =   "Columns"
      Height          =   375
      Left            =   120
      TabIndex        =   16
      Top             =   4200
      Width           =   975
   End
End
Attribute VB_Name = "SendTextData"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Private Const RND_RANGE_SIZE = 10
Private Const ORIGIN_WINTYPE_WKS = 2

'Global variable to hold the reference to an instance of Origin
'It will be initialized by ConnectOrigin_Click event
Dim OriginApp As Origin.Application
Dim wks As Origin.Worksheet
Dim nRows As Integer

Private Sub chkSaveProject_Click()
    If chkSaveProject Then
        ebSaveFileName.Enabled = True
    Else
        ebSaveFileName.Enabled = False
    End If
End Sub

Private Sub chkShowOrigin_Click()
    If OriginApp Is Nothing Then
        Exit Sub
    End If
    Dim i As Integer
    If chkShowOrigin.Value Then
        i = 1
    Else
        i = 0
    End If
    
    Dim str As String
    str = "doc -m " + CStr(i)
    OriginApp.Execute (str)
End Sub

Private Sub ClearWks_Click()
    If Not wks Is Nothing Then
        Dim bRet As Boolean
        bRet = wks.ClearData(0, -1)
        nRows = 0
    End If
End Sub

Private Sub ConnectOrigin_Click()
    'Get a reference to the Origin Automation Server object
    'Origin.Application to start a new Origin instance
    'Origin.ApplicationSI to use an existing Origin instance
    If ConnectExistingOneFirst.Value Then
        Set OriginApp = GetObject("", "Origin.ApplicationSI")
        Call chkShowOrigin_Click
    Else
        Set OriginApp = GetObject("", "Origin.Application")
    End If
        
    Call chkShowOrigin_Click        'apply the show origin option
    OriginApp.Execute ("doc -ss 1") 'turn on session saving asking block
    
    'Initialize worksheet controls
    ebSaveFileName = OriginApp.LTStr("%Y") + OriginApp.LTStr("%G")
    
    'Initialize random-number generator.
    Randomize 'No argument to seed based on the system timer.
    
    nRows = 0
    'Enable controls require an Origin instance
    DisconnectOrigin.Enabled = True
    SendData.Enabled = True
    ClearWks.Enabled = True
    chkSaveProject.Enabled = True
    chkAppend.Enabled = True
    
    'Disable controls to connect to an instance of Origin
    ConnectOrigin.Enabled = False
    AlwaysCreateNew.Enabled = False
    ConnectExistingOneFirst.Enabled = False
    chExitOrigin.Enabled = True
End Sub

Private Sub DisconnectOrigin_Click()
    If chkSaveProject.Value Then
        OriginApp.Save (ebSaveFileName.Text)
    End If
    
    If chExitOrigin.Value Then
        If Not wks Is Nothing Then
            Set wks = Nothing
        End If
        'OriginApp.Execute ("exit")
        OriginApp.Exit
    End If
    Set OriginApp = Nothing
       
    'Disable controls require an Origin instance
    DisconnectOrigin.Enabled = False
    SendData.Enabled = False
    ClearWks.Enabled = False
    chkSaveProject.Enabled = False
    chkAppend.Enabled = False
    chExitOrigin.Enabled = False
    
    'Enable controls to connect to an instance of Origin
    ConnectOrigin.Enabled = True
    AlwaysCreateNew.Enabled = True
    ConnectExistingOneFirst.Enabled = True
End Sub

Private Sub Form_Load()
    'Initialize worksheet controls
    ebWkBName.Text = "Book1"
    ebWksName.Text = "Sheet1"
    ebRows.Text = "5"
    ebCols.Text = "2"
    ebTextPrefix.Text = "row"
    
    'Set default connecting option
    ConnectExistingOneFirst.Value = True
End Sub

Private Sub Form_Unload(Cancel As Integer)
    'Do nothing
End Sub

Private Sub SendData_Click()
    Dim str As String
    Dim d As Double
    Dim b As Boolean
    Dim data() As Integer
    Dim saData() As String
    Dim i As Integer, iRows As Integer, iCols As Integer, iRowStart As Integer
    Dim wkbook As Origin.WorksheetPage
    
    'Get number of requested rows
    iRows = CInt(ebRows.Text)
    If iRows < 1 Then
        MsgBox ("Number of rows must be greater than zero.")
        Exit Sub
    End If
        
    'Get number of requested columns
    iCols = CInt(ebCols.Text)
    If iCols < 1 Then
        MsgBox ("Number of columns must be greater than zero.")
        Exit Sub
    End If
    
    'Check if specified workbook exists and create it if necessary
    Set wkbook = OriginApp.WorksheetPages(ebWkBName.Text)
    If wkbook Is Nothing Then
        ebWkBName.Text = OriginApp.CreatePage(ORIGIN_WINTYPE_WKS, ebWkBName.Text, "w")
        Set wkbook = OriginApp.WorksheetPages(ebWkBName.Text)
        If wkbook Is Nothing Then
            MsgBox ("Failed to find and create specified workbook.")
            Exit Sub
        End If
    End If

    'Check if specified worksheet exists and create it if necessary
    'Sophy 12/9/2009 SUPPORT_NUMERIC_SHEETNAME_MAKE_NEW_SHEET_CREATE_EVEN_IF_EXIST
    'Set wks = OriginApp.FindWorksheet("[" + ebWkBName.Text + "]" + ebWksName.Text
    Dim BookName As String
    Dim SheetName As String
    Dim BookSheetName As String
    SheetName = ebWksName.Text
    BookName = ebWkBName.Text
    SheetName = Chr$(34) & SheetName & Chr$(34)
    BookSheetName = "[" + BookName + "]" + SheetName
    Set wks = OriginApp.FindWorksheet(BookSheetName)
    'end SUPPORT_NUMERIC_SHEETNAME_MAKE_NEW_SHEET_CREATE_EVEN_IF_EXIST
    If wks Is Nothing Then
        Set wks = wkbook.Layers.Add(ebWksName.Text)
        If wks Is Nothing Then
            MsgBox ("Fail to find and create specified worksheet.")
            Exit Sub
        End If
    End If

    'Get the first target row based on the Append check box
    If chkAppend.Value Then
        iRowStart = -1 'Append data as new rows
    Else
        nRows = 0
        iRowStart = 0 'Start at row zero to replace target
    End If
    
    'Make source data
    ReDim saData(0 To iRows - 1) '-1 because we use a zero based index
    If iCols > 1 Then
        ReDim data(0 To iRows - 1, 0 To iCols - 2) '-1 because we use a zero based index
    End If
    For iRow = 0 To iRows - 1
        saData(iRow) = ebTextPrefix.Text + CStr(nRows + iRow)
        For iCol = 0 To iCols - 2
            iLower = iCol * RND_RANGE_SIZE
            iUpper = iLower + RND_RANGE_SIZE
            data(iRow, iCol) = Int((iUpper - iLower) * Rnd + iLower)
        Next iCol
    Next iRow
    
    nRows = nRows + iRows
    'Put the source data into the target worksheet
    b = wks.SetData(saData, iRowStart, 0)
    b = wks.SetData(data, iRowStart, 1)
End Sub

